# SmartINBOX Project

## Overview

SmartINBOX is a modern email platform designed for teams and professionals. This project provides a simplified implementation of the SmartINBOX system based on the un/inbox GitHub repository, adapted for CloudLinux VPS with cPanel.

## Project Structure

This project contains the following key components:

- **smartinbox_improved.zip**: The complete installation package with all necessary files
- **INSTALLATION_GUIDE.md**: Comprehensive guide for installing SmartINBOX
- **IMPROVEMENTS_SUMMARY.md**: Summary of improvements made to the installation process
- **todo.md**: Project task list and progress tracking

## Installation Package Contents

The `smartinbox_improved.zip` package includes:

- **server.js**: Express.js server application
- **public/**: Frontend HTML, CSS, and JavaScript files
- **start.sh** and **stop.sh**: Service management scripts
- **.env**: Environment configuration file
- **install.sh**: Improved installation script with enhanced options
- **README.md**: Basic documentation
- **INSTALLATION_GUIDE.md**: Detailed installation instructions

## Key Features

SmartINBOX provides:

1. **Team Collaboration**: Share inboxes with your team and collaborate on email conversations
2. **Workflow Management**: Track emails with workflow statuses
3. **Multiple Email Addresses**: Add unlimited email addresses for your organization
4. **Secure Communications**: End-to-end encryption for email communications

## Installation

For detailed installation instructions, please refer to the [Installation Guide](INSTALLATION_GUIDE.md).

Quick start:

```bash
# Download and extract the package
wget https://example.com/smartinbox_improved.zip
unzip smartinbox_improved.zip
cd smartinbox_improved

# Make the installation script executable
chmod +x install.sh

# Run the installation script
sudo ./install.sh
```

For a clean installation (removing existing files):

```bash
sudo ./install.sh --clean
```

## System Requirements

- CloudLinux VPS with cPanel
- PHP 8.2 or higher
- Node.js 20.x or higher
- MariaDB 11.4 or higher
- Apache 2.4 or higher
- Redis (optional but recommended)

## Improvements

This version of SmartINBOX includes several improvements over the original installation process:

1. **Enhanced Installation Script**: Added clean installation option and configurable parameters
2. **Comprehensive Documentation**: Detailed installation guide and troubleshooting section
3. **Improved File Structure**: Organized directory layout with proper permissions
4. **Dual Service Management**: Support for both systemd and PM2

For a complete list of improvements, see the [Improvements Summary](IMPROVEMENTS_SUMMARY.md).

## Service Management

### Using systemd

```bash
sudo systemctl start|stop|restart|status smartinbox.service
```

### Using the Provided Scripts

```bash
cd /path/to/smartinbox
./start.sh
./stop.sh
```

### Using PM2

```bash
cd /path/to/smartinbox
pm2 start|stop|restart|status ecosystem.config.js
```

## Troubleshooting

For common issues and their solutions, please refer to the Troubleshooting section in the [Installation Guide](INSTALLATION_GUIDE.md).

## Next Steps

After installation:

1. Configure your domain in cPanel
2. Set up SSL certificates
3. Configure email settings in the `.env` file
4. Test the complete email functionality
5. Set up regular backups

## Support

For support, please contact support@smartinbox.com or visit our website at https://www.smartinbox.com.