"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.emitLogRecord = void 0;
const api_logs_1 = require("@opentelemetry/api-logs");
const npmLevels = {
    error: api_logs_1.SeverityNumber.ERROR,
    warn: api_logs_1.SeverityNumber.WARN,
    info: api_logs_1.SeverityNumber.INFO,
    http: api_logs_1.SeverityNumber.DEBUG3,
    verbose: api_logs_1.SeverityNumber.DEBUG2,
    debug: api_logs_1.SeverityNumber.DEBUG,
    silly: api_logs_1.SeverityNumber.TRACE,
};
const sysLoglevels = {
    emerg: api_logs_1.SeverityNumber.FATAL3,
    alert: api_logs_1.SeverityNumber.FATAL2,
    crit: api_logs_1.SeverityNumber.FATAL,
    error: api_logs_1.SeverityNumber.ERROR,
    warning: api_logs_1.SeverityNumber.WARN,
    notice: api_logs_1.SeverityNumber.INFO2,
    info: api_logs_1.SeverityNumber.INFO,
    debug: api_logs_1.SeverityNumber.DEBUG,
};
const cliLevels = {
    error: api_logs_1.SeverityNumber.ERROR,
    warn: api_logs_1.SeverityNumber.WARN,
    help: api_logs_1.SeverityNumber.INFO3,
    data: api_logs_1.SeverityNumber.INFO2,
    info: api_logs_1.SeverityNumber.INFO,
    debug: api_logs_1.SeverityNumber.DEBUG,
    prompt: api_logs_1.SeverityNumber.TRACE4,
    verbose: api_logs_1.SeverityNumber.TRACE3,
    input: api_logs_1.SeverityNumber.TRACE2,
    silly: api_logs_1.SeverityNumber.TRACE,
};
function getSeverityNumber(level) {
    var _a, _b;
    return (_b = (_a = npmLevels[level]) !== null && _a !== void 0 ? _a : sysLoglevels[level]) !== null && _b !== void 0 ? _b : cliLevels[level];
}
function emitLogRecord(record, logger) {
    const { message, level } = record, splat = __rest(record, ["message", "level"]);
    const attributes = {};
    for (const key in splat) {
        if (Object.prototype.hasOwnProperty.call(splat, key)) {
            attributes[key] = splat[key];
        }
    }
    const logRecord = {
        severityNumber: getSeverityNumber(level),
        severityText: level,
        body: message,
        attributes: attributes,
    };
    logger.emit(logRecord);
}
exports.emitLogRecord = emitLogRecord;
//# sourceMappingURL=utils.js.map