import { entityKind } from "../../../entity.js";
import { PgColumn, PgColumnBuilder } from "../common.js";
class PgVectorBuilder extends PgColumnBuilder {
  static [entityKind] = "PgVectorBuilder";
  constructor(name, config) {
    super(name, "array", "PgVector");
    this.config.dimensions = config.dimensions;
  }
  /** @internal */
  build(table) {
    return new PgVector(table, this.config);
  }
}
class PgVector extends PgColumn {
  static [entityKind] = "PgVector";
  dimensions = this.config.dimensions;
  getSQLType() {
    return `vector(${this.dimensions})`;
  }
  mapToDriverValue(value) {
    return JSON.stringify(value);
  }
  mapFromDriverValue(value) {
    return value.slice(1, -1).split(",").map((v) => Number.parseFloat(v));
  }
}
function vector(name, config) {
  return new PgVectorBuilder(name, config);
}
export {
  PgVector,
  PgVectorBuilder,
  vector
};
//# sourceMappingURL=vector.js.map