"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.trpcServer = void 0;
const fetch_1 = require("@trpc/server/adapters/fetch");
const trpcServer = ({ endpoint = '/trpc', createContext, ...rest }) => {
    return async (c) => {
        const res = (0, fetch_1.fetchRequestHandler)({
            ...rest,
            createContext: async (opts) => ({
                ...(createContext ? await createContext(opts, c) : {}),
                // propagate env by default
                env: c.env,
            }),
            endpoint,
            req: c.req.raw,
        }).then((res) => c.body(res.body, res));
        return res;
    };
};
exports.trpcServer = trpcServer;
