import { fetchRequestHandler } from '@trpc/server/adapters/fetch';
export const trpcServer = ({ endpoint = '/trpc', createContext, ...rest }) => {
    return async (c) => {
        const res = fetchRequestHandler({
            ...rest,
            createContext: async (opts) => ({
                ...(createContext ? await createContext(opts, c) : {}),
                // propagate env by default
                env: c.env,
            }),
            endpoint,
            req: c.req.raw,
        }).then((res) => c.body(res.body, res));
        return res;
    };
};
