import haveIBeenPwned from './haveIBeenPwned.esm.js';

/*
 * -------------------------------------------------------------------------------
 *  Have i been pwned matching factory ---------------------------------------------------
 * -------------------------------------------------------------------------------
 */
var MatchPwned = ((universalFetch, {
  url,
  networkErrorHandler
}) => {
  return class MatchPwned {
    async match({
      password
    }) {
      const matches = [];
      const pwned = await haveIBeenPwned(password, {
        universalFetch,
        url,
        networkErrorHandler
      });
      if (pwned) {
        // @ts-ignore
        matches.push({
          pattern: 'pwned',
          pwnedAmount: parseInt(pwned.split(':')[1], 10),
          i: 0,
          j: password.length - 1,
          token: password
        });
      }
      return matches;
    }
  };
});

export { MatchPwned as default };
//# sourceMappingURL=matching.esm.js.map
