import type { ColumnBuilderBaseConfig } from "../../column-builder.js";
import type { ColumnBaseConfig } from "../../column.js";
import { entityKind } from "../../entity.js";
import type { Writable } from "../../utils.js";
import { MySqlColumn, MySqlColumnBuilder } from "./common.js";
export type MySqlTextColumnType = 'tinytext' | 'text' | 'mediumtext' | 'longtext';
export type MySqlTextBuilderInitial<TName extends string, TEnum extends [string, ...string[]]> = MySqlTextBuilder<{
    name: TName;
    dataType: 'string';
    columnType: 'MySqlText';
    data: TEnum[number];
    driverParam: string;
    enumValues: TEnum;
    generated: undefined;
}>;
export declare class MySqlTextBuilder<T extends ColumnBuilderBaseConfig<'string', 'MySqlText'>> extends MySqlColumnBuilder<T, {
    textType: MySqlTextColumnType;
    enumValues: T['enumValues'];
}> {
    static readonly [entityKind]: string;
    constructor(name: T['name'], textType: MySqlTextColumnType, config: MySqlTextConfig<T['enumValues']>);
}
export declare class MySqlText<T extends ColumnBaseConfig<'string', 'MySqlText'>> extends MySqlColumn<T, {
    textType: MySqlTextColumnType;
    enumValues: T['enumValues'];
}> {
    static readonly [entityKind]: string;
    private textType;
    readonly enumValues: T["enumValues"];
    getSQLType(): string;
}
export interface MySqlTextConfig<TEnum extends readonly string[] | string[] | undefined> {
    enum?: TEnum;
}
export declare function text<TName extends string, U extends string, T extends Readonly<[U, ...U[]]>>(name: TName, config?: MySqlTextConfig<T | Writable<T>>): MySqlTextBuilderInitial<TName, Writable<T>>;
export declare function tinytext<TName extends string, U extends string, T extends Readonly<[U, ...U[]]>>(name: TName, config?: MySqlTextConfig<T | Writable<T>>): MySqlTextBuilderInitial<TName, Writable<T>>;
export declare function mediumtext<TName extends string, U extends string, T extends Readonly<[U, ...U[]]>>(name: TName, config?: MySqlTextConfig<T | Writable<T>>): MySqlTextBuilderInitial<TName, Writable<T>>;
export declare function longtext<TName extends string, U extends string, T extends Readonly<[U, ...U[]]>>(name: TName, config?: MySqlTextConfig<T | Writable<T>>): MySqlTextBuilderInitial<TName, Writable<T>>;
