import type { ColumnBuilderBaseConfig } from "../../column-builder.cjs";
import type { ColumnBaseConfig } from "../../column.cjs";
import { entityKind } from "../../entity.cjs";
import { PgColumn } from "./common.cjs";
import { PgDateColumnBaseBuilder } from "./date.common.cjs";
export type PgDateBuilderInitial<TName extends string> = PgDateBuilder<{
    name: TName;
    dataType: 'date';
    columnType: 'PgDate';
    data: Date;
    driverParam: string;
    enumValues: undefined;
    generated: undefined;
}>;
export declare class PgDateBuilder<T extends ColumnBuilderBaseConfig<'date', 'PgDate'>> extends PgDateColumnBaseBuilder<T> {
    static readonly [entityKind]: string;
    constructor(name: T['name']);
}
export declare class PgDate<T extends ColumnBaseConfig<'date', 'PgDate'>> extends PgColumn<T> {
    static readonly [entityKind]: string;
    getSQLType(): string;
    mapFromDriverValue(value: string): Date;
    mapToDriverValue(value: Date): string;
}
export type PgDateStringBuilderInitial<TName extends string> = PgDateStringBuilder<{
    name: TName;
    dataType: 'string';
    columnType: 'PgDateString';
    data: string;
    driverParam: string;
    enumValues: undefined;
    generated: undefined;
}>;
export declare class PgDateStringBuilder<T extends ColumnBuilderBaseConfig<'string', 'PgDateString'>> extends PgDateColumnBaseBuilder<T> {
    static readonly [entityKind]: string;
    constructor(name: T['name']);
}
export declare class PgDateString<T extends ColumnBaseConfig<'string', 'PgDateString'>> extends PgColumn<T> {
    static readonly [entityKind]: string;
    getSQLType(): string;
}
export declare function date<TName extends string>(name: TName, config?: {
    mode: 'string';
}): PgDateStringBuilderInitial<TName>;
export declare function date<TName extends string>(TName: TName, config?: {
    mode: 'date';
}): PgDateBuilderInitial<TName>;
