import { entityKind } from "../../entity.js";
import { sql } from "../../sql/sql.js";
import { PgColumn, PgColumnBuilder } from "./common.js";
class PgUUIDBuilder extends PgColumnBuilder {
  static [entityKind] = "PgUUIDBuilder";
  constructor(name) {
    super(name, "string", "PgUUID");
  }
  /**
   * Adds `default gen_random_uuid()` to the column definition.
   */
  defaultRandom() {
    return this.default(sql`gen_random_uuid()`);
  }
  /** @internal */
  build(table) {
    return new PgUUID(table, this.config);
  }
}
class PgUUID extends PgColumn {
  static [entityKind] = "PgUUID";
  getSQLType() {
    return "uuid";
  }
}
function uuid(name) {
  return new PgUUIDBuilder(name);
}
export {
  PgUUID,
  PgUUIDBuilder,
  uuid
};
//# sourceMappingURL=uuid.js.map